#include <iostream>
#include <cmath>
using namespace std;

const double INF = 1e18;

int main() {
    int n;
    cin >> n;

    double jarboli[2000], h[2000];
    int idx[2000];

    for (int i = 0; i < n; i++) cin >> jarboli[i];
    for (int i = 0; i < n; i++) cin >> h[i];
    for (int i = 0; i < n; i++) idx[i] = i;


    for (int i = 0; i < n; i++) {
        for (int j = i + 1; j < n; j++) {
            if (jarboli[j] < jarboli[i]) {
                swap(jarboli[i], jarboli[j]);
                swap(h[i], h[j]);
                swap(idx[i], idx[j]);
            }
        }
    }

    double rastojanja[2000];
    for (int i = 0; i < n; i++) rastojanja[i] = -1;

    for (int i = 0; i < n; i++) {
        double best = INF;


        for (int j = 0; j < n; j++) {
            if (j == i) continue;
            if (h[j] >= h[i]) {
                double dx = jarboli[j] - jarboli[i];
                double dy = h[j] - h[i];
                best = min(best, sqrt(dx * dx + dy * dy));
            }
        }


        if (i > 0 && h[i - 1] >= h[i]) {
            double xc = jarboli[i - 1] + (h[i - 1] - h[i]);
            if (xc >= jarboli[i - 1] && xc <= jarboli[i]) {
                double dx = xc - jarboli[i];
                best = min(best, abs(dx));
            }
        }


        if (i + 1 < n && h[i + 1] >= h[i]) {
            double xc = jarboli[i + 1] - (h[i + 1] - h[i]);
            if (xc >= jarboli[i] && xc <= jarboli[i + 1]) {
                double dx = xc - jarboli[i];
                best = min(best, abs(dx));
            }
        }

        if (best < INF) rastojanja[idx[i]] = best;
    }

    for (int i = 0; i < n; i++) {
        if (rastojanja[i] < 0) cout << -1 << "\n";
        else cout << (int)round(rastojanja[i]) << "\n";
    }

    return 0;
}